package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActAlreadySyncExternalUserModel;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserDO;
import com.tydic.dyc.act.service.api.DycActAddListActAlreadySyncExternalUserService;
import com.tydic.dyc.act.service.bo.ActAlreadySyncExternalUserReqBO;
import com.tydic.dyc.act.service.bo.ActAlreadySyncExternalUserRspBO;
import com.tydic.dyc.act.service.bo.DycActTaskDealActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActAddListActAlreadySyncExternalUserServiceImpl
 * 说明：
 * 时间： 2024-04-15 17:03
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActAddListActAlreadySyncExternalUserServiceImpl implements DycActAddListActAlreadySyncExternalUserService {
    @Autowired
    private DycActAlreadySyncExternalUserModel dycActAlreadySyncExternalUserModel;


    @Override
    public ActAlreadySyncExternalUserRspBO addListActAlreadySyncExternalUser(List<ActAlreadySyncExternalUserReqBO> reqBO) {

        List<ActAlreadySyncExternalUserDO> userDOS = JSON.parseArray(JSON.toJSONString(reqBO), ActAlreadySyncExternalUserDO.class);
        dycActAlreadySyncExternalUserModel.addListActAlreadySyncExternalUser(userDOS);
        ActAlreadySyncExternalUserRspBO rspBO = new ActAlreadySyncExternalUserRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
