package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActAutoEffectActivityTimeService;
import com.tydic.dyc.act.service.bo.DycActAutoEffectActivityTimeReqBO;
import com.tydic.dyc.act.service.bo.DycActAutoEffectActivityTimeRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 说明：活动自动生效定时任务服务
 *
 * @author zhoulu
 * @date 2023年12月21日 15:32
 */
@HTServiceImpl
public class DycActAutoEffectActivityTimeServiceImpl implements DycActAutoEffectActivityTimeService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActAutoEffectActivityTimeRspBO autoEffectActivity(DycActAutoEffectActivityTimeReqBO reqBO) {
        List<Long> activityIds = dycActActivityModel.autoEffectActivity(new DycActivityDO());
        DycActAutoEffectActivityTimeRspBO rspBO = new DycActAutoEffectActivityTimeRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        rspBO.setActivityIds(activityIds);
        return rspBO;
    }
}
