package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActAutoLoseEffectActivityTimeService;
import com.tydic.dyc.act.service.bo.DycActAutoLoseEffectActivityTimeReqBO;
import com.tydic.dyc.act.service.bo.DycActAutoLoseEffectActivityTimeRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActAutoLoseEffectActivityTimeServiceImpl
 * 说明：活动自动失效定时任务服务
 * 时间： 2023-12-21 15:32
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActAutoLoseEffectActivityTimeServiceImpl implements DycActAutoLoseEffectActivityTimeService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActAutoLoseEffectActivityTimeRspBO autoLoseEffectActivity(DycActAutoLoseEffectActivityTimeReqBO reqBO) {
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActActivityModel.autoLoseEffectActivity(dycActivityDO);
        DycActAutoLoseEffectActivityTimeRspBO rspBO = new DycActAutoLoseEffectActivityTimeRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
