package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActBatchModifyActivityUserScoresService;
import com.tydic.dyc.act.service.bo.DycActBatchModifyActivityUserScoresReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchModifyActivityUserScoresRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchModifyActivityUserScoresServiceImpl
 * 说明：活动用户积分修改（批量）服务
 * 时间： 2023-12-20 14:56
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchModifyActivityUserScoresServiceImpl implements DycActBatchModifyActivityUserScoresService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchModifyActivityUserScoresRspBO batchModifyActivityUserScores(DycActBatchModifyActivityUserScoresReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        DycActivityUserInfo dycActivityUserInfo = dycActActivityModel.batchModifyActivityUserScores(dycActivityDO);
        DycActBatchModifyActivityUserScoresRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityUserInfo), DycActBatchModifyActivityUserScoresRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
