package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityChangeCommodityPoolService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeCommodityPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeCommodityPoolRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchRemoveActivityChangeCommodityPoolServiceImpl
 * 说明：活动变更商品池移除（批量）服务
 * 时间： 2023-12-25 14:20
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchRemoveActivityChangeCommodityPoolServiceImpl implements DycActBatchRemoveActivityChangeCommodityPoolService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;


    @Override
    public DycActBatchRemoveActivityChangeCommodityPoolRspBO batchRemoveActivityChangeCommodityPool(DycActBatchRemoveActivityChangeCommodityPoolReqBO reqBO) {
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeModel.batchRemoveActivityChangeCommodityPool(dycActivityChangeDO);
        DycActBatchRemoveActivityChangeCommodityPoolRspBO rspBO = new DycActBatchRemoveActivityChangeCommodityPoolRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
