package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityChangeSupplierService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeSupplierReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeSupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更供应商移除（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月22日 15:40
 */
@HTServiceImpl
public class DycActBatchRemoveActivityChangeSupplierServiceImpl implements DycActBatchRemoveActivityChangeSupplierService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchRemoveActivityChangeSupplierRspBO batchRemoveActivityChangeSupplier(DycActBatchRemoveActivityChangeSupplierReqBO reqBO) {
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeModel.batchRemoveActivityChangeSupplier(dycActivityChangeDO);
        DycActBatchRemoveActivityChangeSupplierRspBO rspBO = new DycActBatchRemoveActivityChangeSupplierRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
