package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityChangeUserService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeUserReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchRemoveActivityChangeUserServiceImpl
 * 说明：活动变更用户移除（批量）服务
 * 时间： 2023-12-26 16:04
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchRemoveActivityChangeUserServiceImpl implements DycActBatchRemoveActivityChangeUserService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;


    @Override
    public DycActBatchRemoveActivityChangeUserRspBO batchRemoveActivityChangeUser(DycActBatchRemoveActivityChangeUserReqBO reqBo) {
        DycActBatchRemoveActivityChangeUserRspBO rspBo = new DycActBatchRemoveActivityChangeUserRspBO();
        DycActivityChangeDO saveReqBo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        dycActivityChangeModel.batchRemoveActivityChangeUser(saveReqBo);
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
