package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityUserService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityUserReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchRemoveActivityUserServiceImpl
 * 说明：活动用户移除（批量）服务
 * 时间： 2023-12-20 10:35
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchRemoveActivityUserServiceImpl implements DycActBatchRemoveActivityUserService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchRemoveActivityUserRspBO batchRemoveActivityUser(DycActBatchRemoveActivityUserReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        DycActivityUserInfo userInfo = dycActActivityModel.batchRemoveActivityUser(dycActivityDO);
        DycActBatchRemoveActivityUserRspBO rspBO = JSON.parseObject(JSON.toJSONString(userInfo), DycActBatchRemoveActivityUserRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
