package com.tydic.dyc.act.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActBatchSelectActiveCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActActivityCommodityCatalogInfoBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogRspBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityReqBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：DycActBatchSelectActiveCommodityCatalogServiceImpl
 * 说明：
 * 时间： 2023-12-15 10:22
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActiveCommodityCatalogServiceImpl implements DycActBatchSelectActiveCommodityCatalogService {

    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @Override
    public DycActBatchSelectActivityCommodityCatalogRspBO batchSelectActivityCommodityCatalog(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        //入参校验
        this.verifyParam(reqBO);
        //商品类目处理
        List<DycActiveCommodityCatalogInfo> commodityCatalogInfoBos = getDycActiveCommodityCatalogInfos(reqBO);

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setCreateUserId(reqBO.getUserId());
        dycActivityDO.setCreateUserName(reqBO.getName());
        dycActivityDO.setCommodityCatalogInfoBOS(commodityCatalogInfoBos);
        DycActiveCommodityCatalogInfo catalogInfo = dycActActivityModel.batchSelectActivityCommodityCatalog(dycActivityDO);

        DycActBatchSelectActivityCommodityCatalogRspBO rspBO = JSON.parseObject(JSON.toJSONString(catalogInfo), DycActBatchSelectActivityCommodityCatalogRspBO.class);

        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 商品类目处理
     * @param reqBO
     * @return
     */
    private List<DycActiveCommodityCatalogInfo> getDycActiveCommodityCatalogInfos(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {
        List<Long> threeCatalogIds = reqBO.getCommodityCatalogInfoBOS().stream().map(DycActActivityCommodityCatalogInfoBO::getThreeCatalogId).distinct().map(Convert::toLong).collect(Collectors.toList());
        ActSkuGuideReqBO qryActSkuGuideReqBo = new ActSkuGuideReqBO();
        qryActSkuGuideReqBo.setGuideCatalogIdList(threeCatalogIds);
        ActSkuGuideListRspBO actSkuGuideListRspBO = dycActSkuInfoModel.getCatalogBOByCatalogIds(qryActSkuGuideReqBo);
        if(MapUtil.isEmpty(actSkuGuideListRspBO.getCatalogBOByCatalogIds())){
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"查询商品类目失败");
        }
        Map<Long, ActSkuGuideBO> actSkuGuideBoMap = actSkuGuideListRspBO.getCatalogBOByCatalogIds();
        List<DycActiveCommodityCatalogInfo> commodityCatalogInfoBos = new ArrayList<>(reqBO.getCommodityCatalogInfoBOS().size());
        for (DycActActivityCommodityCatalogInfoBO each : reqBO.getCommodityCatalogInfoBOS()) {
            ActSkuGuideBO actSkuGuideBO = actSkuGuideBoMap.get(Long.parseLong(each.getThreeCatalogId()));
            if(actSkuGuideBO == null){
                continue;
            }
            DycActiveCommodityCatalogInfo dycActiveCommodityCatalogInfo = JSON.parseObject(JSON.toJSONString(each), DycActiveCommodityCatalogInfo.class);
            dycActiveCommodityCatalogInfo.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
            dycActiveCommodityCatalogInfo.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
            dycActiveCommodityCatalogInfo.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
            dycActiveCommodityCatalogInfo.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
            dycActiveCommodityCatalogInfo.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
            commodityCatalogInfoBos.add(dycActiveCommodityCatalogInfo);
        }
        return commodityCatalogInfoBos;
    }

    /**
     * 参数校验
     */
    private void verifyParam(DycActBatchSelectActivityCommodityCatalogReqBO reqBO){
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"入参不能为空");
        }
        if (null == reqBO.getActivityId()) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"活动id不能为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getCommodityCatalogInfoBOS())){
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品类目不能为空");
        }
        for (DycActActivityCommodityCatalogInfoBO commodityCatalogInfoBO : reqBO.getCommodityCatalogInfoBOS()) {
            if(StringUtils.isBlank(commodityCatalogInfoBO.getThreeCatalogId())){
                throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"入参，商品三级类目不能为空");
            }
        }
    }
}
