package com.tydic.dyc.act.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityCatalogService;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 说明：活动变更商品类型选择（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月25日 15:49
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeCommodityCatalogServiceImpl implements DycActBatchSelectActivityChangeCommodityCatalogService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;
    @Override
    public DycActBatchSelectActivityChangeCommodityCatalogRspBO batchSelectActivityChangeCommodityCatalog(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBo) {
        //入参校验
        this.verifyParam(reqBo);
        //商品类目处理
        List<DycActivityChangeRelaCommodityCatalogInfo> commodityCatalogInfoBos = getDycActiveCommodityCatalogInfos(reqBo);

        DycActivityChangeDO dycActivityChangeDo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        dycActivityChangeDo.setCreateUserId(reqBo.getUserId());
        dycActivityChangeDo.setCreateUserName(reqBo.getName());
        dycActivityChangeDo.setCommodityCatalogList(commodityCatalogInfoBos);
        dycActivityChangeModel.batchSelectActivityChangeCommodityCatalog(dycActivityChangeDo);
        DycActBatchSelectActivityChangeCommodityCatalogRspBO rspBo = new DycActBatchSelectActivityChangeCommodityCatalogRspBO();
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
    /**
     * 商品类目处理
     * @param reqBO
     * @return
     */
    private List<DycActivityChangeRelaCommodityCatalogInfo> getDycActiveCommodityCatalogInfos(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBO) {
        List<Long> threeCatalogIds = reqBO.getCommodityCatalogList().stream().map(DycActivityChangeRelaCommodityCatalogInfoBO::getThreeCatalogId).distinct().map(Convert::toLong).collect(Collectors.toList());
        ActSkuGuideReqBO qryActSkuGuideReqBo = new ActSkuGuideReqBO();
        qryActSkuGuideReqBo.setGuideCatalogIdList(threeCatalogIds);
        ActSkuGuideListRspBO actSkuGuideListRspBO = dycActSkuInfoModel.getCatalogBOByCatalogIds(qryActSkuGuideReqBo);
        if(MapUtil.isEmpty(actSkuGuideListRspBO.getCatalogBOByCatalogIds())){
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"查询商品类目失败");
        }
        Map<Long, ActSkuGuideBO> actSkuGuideBoMap = actSkuGuideListRspBO.getCatalogBOByCatalogIds();
        List<DycActivityChangeRelaCommodityCatalogInfo> commodityCatalogInfoBos = new ArrayList<>(reqBO.getCommodityCatalogList().size());
        for (DycActivityChangeRelaCommodityCatalogInfoBO each : reqBO.getCommodityCatalogList()) {
            ActSkuGuideBO actSkuGuideBO = actSkuGuideBoMap.get(Long.parseLong(each.getThreeCatalogId()));
            if(actSkuGuideBO == null){
                continue;
            }
            DycActivityChangeRelaCommodityCatalogInfo dycActiveCommodityCatalogInfo = JSON.parseObject(JSON.toJSONString(each), DycActivityChangeRelaCommodityCatalogInfo.class);
            dycActiveCommodityCatalogInfo.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
            dycActiveCommodityCatalogInfo.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
            dycActiveCommodityCatalogInfo.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
            dycActiveCommodityCatalogInfo.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
            dycActiveCommodityCatalogInfo.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
            commodityCatalogInfoBos.add(dycActiveCommodityCatalogInfo);
        }
        return commodityCatalogInfoBos;
    }

    /**
     * 参数校验
     */
    private void verifyParam(DycActBatchSelectActivityChangeCommodityCatalogReqBO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getChangeId() == null) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "变更单id不能为空");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "操作人Id不能为空");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "操作人名称不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getCommodityCatalogList())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "商品类型列表不能为空");
        }
        for (DycActivityChangeRelaCommodityCatalogInfoBO commodityCatalogInfoBO : reqBo.getCommodityCatalogList()) {
            if(org.apache.commons.lang3.StringUtils.isBlank(commodityCatalogInfoBO.getThreeCatalogId())){
                throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"入参，商品三级类目不能为空");
            }
        }

    }
}
