package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityPoolService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityPoolRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivityChangeCommodityPoolServiceImpl
 * 说明：活动变更商品池选择（批量）服务
 * 时间： 2023-12-25 11:19
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeCommodityPoolServiceImpl implements DycActBatchSelectActivityChangeCommodityPoolService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchSelectActivityChangeCommodityPoolRspBO batchSelectActivityChangeCommodityPool(DycActBatchSelectActivityChangeCommodityPoolReqBO reqBO) {
        DycActivityChangeDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        DycActivityChangeRelaCommodityPoolInfo userInfo = dycActivityChangeModel.batchSelectActivityChangeCommodityPool(dycActivityDO);
        DycActBatchSelectActivityChangeCommodityPoolRspBO rspBO = JSON.parseObject(JSON.toJSONString(userInfo), DycActBatchSelectActivityChangeCommodityPoolRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
