package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeCommodityService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * 说明：活动变更商品选择（批量）服务
 * @author zhoulu
 * @date 2023年12月26日 14:30
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeCommodityServiceImpl implements DycActBatchSelectActivityChangeCommodityService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchSelectActivityChangeCommodityRspBO batchSelectActivityChangeCommodity(DycActBatchSelectActivityChangeCommodityReqBO reqBo) {
        if (reqBo.getChangeId() == null) {
            throw new ZTBusinessException("变更单id不能为空!");
        }
        if (CollectionUtils.isEmpty(reqBo.getCommodityList())) {
            throw new ZTBusinessException("商品列表不能为空!");
        }
        if (reqBo.getUserId() == null) {
            throw new ZTBusinessException("操作人Id不能为空!");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new ZTBusinessException("操作人名称不能为空!");
        }
        DycActivityChangeDO dycActivityChangeDo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        dycActivityChangeDo.setCreateUserId(reqBo.getUserId());
        dycActivityChangeDo.setCreateUserName(reqBo.getName());
        dycActivityChangeModel.batchSelectActivityChangeCommodity(dycActivityChangeDo);
        DycActBatchSelectActivityChangeCommodityRspBO rspBo = new DycActBatchSelectActivityChangeCommodityRspBO();
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
