package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeSupplierService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeSupplierReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeSupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更供应商选择（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月22日 15:23
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeSupplierServiceImpl implements DycActBatchSelectActivityChangeSupplierService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchSelectActivityChangeSupplierRspBO batchSelectActivityChangeSupplier(DycActBatchSelectActivityChangeSupplierReqBO reqBO) {
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeModel.batchSelectActivityChangeSupplier(dycActivityChangeDO);
        DycActBatchSelectActivityChangeSupplierRspBO rspBO = new DycActBatchSelectActivityChangeSupplierRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
