package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeUserService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeUserReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeUserRspBO;
import com.tydic.dyc.act.service.bo.DycActivityChangeUserInfoBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/**
 * 标题：DycActBatchSelectActivityChangeUserServiceImpl
 * 说明：活动变更用户选择（批量）服务
 * 时间： 2023-12-26 14:17
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeUserServiceImpl implements DycActBatchSelectActivityChangeUserService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchSelectActivityChangeUserRspBO batchSelectActivityChangeUser(DycActBatchSelectActivityChangeUserReqBO reqBo) {
        //校验是否有相同数据
        if (!ObjectUtils.isEmpty(reqBo) || !CollectionUtils.isEmpty(reqBo.getUserList())) {
            boolean b = reqBo.getUserList().stream().map(DycActivityChangeUserInfoBO::getActUserName).distinct().count() != reqBo.getUserList().size();
            if(b){
                throw new ZTBusinessException("存在相同的用户！");
            }
        }
        DycActivityChangeDO activityChangeDo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        dycActivityChangeModel.batchSelectActivityChangeUser(activityChangeDo);
        DycActBatchSelectActivityChangeUserRspBO rspBo = new DycActBatchSelectActivityChangeUserRspBO();
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
