package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityCommodityService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivityCommodityServiceImpl
 * 说明：活动商品选择（批量）服务
 * 时间： 2023-12-18 10:47
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityCommodityServiceImpl implements DycActBatchSelectActivityCommodityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;


    @Override
    public DycActBatchSelectActivityCommodityRspBO batchSelectActivityCommodity(DycActBatchSelectActivityCommodityReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setCreateUserId(reqBO.getUserId());
        dycActivityDO.setCreateUserName(reqBO.getName());
        DycActActivityRelaCommodityInfo commodityInfo = dycActActivityModel.batchSelectActivityCommodity(dycActivityDO);

        DycActBatchSelectActivityCommodityRspBO rspBO = JSON.parseObject(JSON.toJSONString(commodityInfo), DycActBatchSelectActivityCommodityRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
