package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.service.api.DycActChangeActivityService;
import com.tydic.dyc.act.service.bo.DycActChangeActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActChangeActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActChangeActivityService
 * 说明：活动变更服务
 * 时间： 2023-12-22 17:06
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActChangeActivityServiceImpl implements DycActChangeActivityService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;


    @Override
    public DycActChangeActivityRspBO changeActivity(DycActChangeActivityReqBO reqBo) {
        check(reqBo);
        DycActivityChangeDO dycActivityChangeDo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        dycActivityChangeDo.setCreateUserId(reqBo.getUserId());
        dycActivityChangeDo.setCreateUserName(reqBo.getName());
        DycActivityChangeInfo dycActivityChangeInfo = dycActivityChangeModel.changeActivity(dycActivityChangeDo);
        return JSON.parseObject(JSON.toJSONString(dycActivityChangeInfo), DycActChangeActivityRspBO.class);
    }

    /**
     * 参数校验
     */
    private void check(DycActChangeActivityReqBO reqBo){
        if (null == reqBo.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (null == reqBo.getUserId()) {
            throw new ZTBusinessException("操作人id不能为空！");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new ZTBusinessException("操作人名称不能为空！");
        }
    }
}
