package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActChangeActivityStateService;
import com.tydic.dyc.act.service.bo.DycActChangeActivityStateReqBO;
import com.tydic.dyc.act.service.bo.DycActChangeActivityStateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动状态变更服务
 *
 * @author zhoulu
 * @date 2023年12月19日 14:11
 */
@HTServiceImpl
public class DycActChangeActivityStateServiceImpl implements DycActChangeActivityStateService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActChangeActivityStateRspBO changeActivityState(DycActChangeActivityStateReqBO reqBO) {
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getOperType())) {
            throw new ZTBusinessException("活动状态不能为空！");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("操作人id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getName())) {
            throw new ZTBusinessException("操作人名称不能为空！");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setActivityState(reqBO.getOperType());
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        dycActActivityModel.changeActivityState(dycActivityDO);
        DycActChangeActivityStateRspBO rspBO = new DycActChangeActivityStateRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
