package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.service.api.DycActCheckOrdIfFinishByActivityIdService;
import com.tydic.dyc.act.service.bo.DycActCheckOrdIfFinishByActivityIdReqBO;
import com.tydic.dyc.act.service.bo.DycActCheckOrdIfFinishByActivityIdRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName DycActCheckOrdIfFinishByActivityIdServiceImpl
 * @Author 14051
 * @Date 2024/4/24 19:54
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActCheckOrdIfFinishByActivityIdServiceImpl implements DycActCheckOrdIfFinishByActivityIdService {

    @Autowired
    private DycActOrderModel dycActOrderModel;

    @Override
    public DycActCheckOrdIfFinishByActivityIdRspBO checkOrderByActivityId(DycActCheckOrdIfFinishByActivityIdReqBO reqBO) {
        DycActCheckOrdIfFinishByActivityIdRspBO rspBO = new DycActCheckOrdIfFinishByActivityIdRspBO();
        DycActOrderQryDO dycActOrderQryDO = new DycActOrderQryDO();
        dycActOrderQryDO.setActivityId(reqBO.getActivityId());
        String orderId = dycActOrderModel.getUnFinishOrderId(dycActOrderQryDO);
        if (StringUtils.isNotBlank(orderId)){
            rspBO.setUnFinishFlag(false);
        } else {
            rspBO.setUnFinishFlag(true);
        }
        return rspBO;
    }
}
