package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.service.api.DycActCodeGenerationService;
import com.tydic.dyc.act.service.bo.DycActCodeGenerationReqBO;
import com.tydic.dyc.act.service.bo.DycActCodeGenerationRspBO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： DycActCodeGenerationServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/8 15:14
 */
@HTServiceImpl
@Slf4j
public class DycActCodeGenerationServiceImpl implements DycActCodeGenerationService {

    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;

    @Override
    public DycActCodeGenerationRspBO dealCodeGeneration(DycActCodeGenerationReqBO reqBO) {
        DycActCodeGenerationRspBO rspBO = new DycActCodeGenerationRspBO();
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcEncodedSerialGetServiceReqBO.setEncodedRuleCode(reqBO.getCode());
        cfcEncodedSerialGetServiceReqBO.setCenter(reqBO.getCenter());
        cfcEncodedSerialGetServiceReqBO.setOrgType("-1");
        cfcEncodedSerialGetServiceReqBO.setNum(reqBO.getCount());
        if (reqBO.getUpperCode() != null && !"".equals(reqBO.getUpperCode())) {
            // 装入上级编码code
            List<String> replaceValue = new ArrayList<>();
            replaceValue.add(reqBO.getUpperCode());
            cfcEncodedSerialGetServiceReqBO.setReplaceValue(replaceValue);
        }
        log.debug("调用编码生成中心入参{}" + JSONObject.toJSONString(cfcEncodedSerialGetServiceReqBO));
        CfcEncodedSerialGetServiceRspBO cfcEncodedSerialGetServiceRspBO = cfcEncodedSerialGetService.getEncodedSerial(cfcEncodedSerialGetServiceReqBO);
        log.debug("调用编码生成中心入参{}" + JSONObject.toJSONString(cfcEncodedSerialGetServiceRspBO));
        rspBO.setCodeList(cfcEncodedSerialGetServiceRspBO.getSerialNoList());
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
