package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.ActAlertAfsOrderInfo;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.DycActDealAlertQryOrderDO;
import com.tydic.dyc.act.service.api.DycActDealAlertQryOrderListService;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @ClassName DycActDealAlertQryOrderListServiceImpl
 * @Author 14051
 * @Date 2024/4/16 16:18
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActDealAlertQryOrderListServiceImpl implements DycActDealAlertQryOrderListService {

    @Autowired
    private DycActOrderModel dycActOrderModel;
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealAlertQryOrderListRspBO qryOrderList(DycActDealAlertQryOrderListReqBO reqBO) {
        DycActDealAlertQryOrderListRspBO rspBO = new DycActDealAlertQryOrderListRspBO();
        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = new DycActDealAlertQryOrderDO();
        dycActDealAlertQryOrderDO.setAlertFlag(reqBO.getAlertFlag());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            dycActDealAlertQryOrderDO.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            dycActDealAlertQryOrderDO.setOrderIds(reqBO.getOrderIds());
        }
        dycActDealAlertQryOrderDO.setDayNum(reqBO.getDayNum());
        List<String> orderIds = dycActOrderModel.qryAlertOrderList(dycActDealAlertQryOrderDO);
        rspBO.setOrderIds(orderIds);
        return rspBO;
    }

    @Override
    public DycActQryAlertOrderListRspBO qryAlertOrderList(DycActDealAlertQryOrderListReqBO reqBO) {
        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = new DycActDealAlertQryOrderDO();
        dycActDealAlertQryOrderDO.setAlertFlag(reqBO.getAlertFlag());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            dycActDealAlertQryOrderDO.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            dycActDealAlertQryOrderDO.setOrderIds(reqBO.getOrderIds());
        }
        List<ActAlertOrderInfo> actAlertOrderInfos = dycActOrderModel.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
        DycActQryAlertOrderListRspBO rspBO = new DycActQryAlertOrderListRspBO();
        rspBO.setDycActAlertOrderInfoBOS(JUtil.jsl(actAlertOrderInfos, DycActAlertOrderInfoBO.class));
        return rspBO;
    }

    @Override
    public DycActDealAlertQryOrderListRspBO qryAfsOrderList(DycActDealAlertQryOrderListReqBO reqBO) {
        DycActDealAlertQryOrderListRspBO rspBO = new DycActDealAlertQryOrderListRspBO();
        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = new DycActDealAlertQryOrderDO();
        dycActDealAlertQryOrderDO.setDayNum(reqBO.getDayNum());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            dycActDealAlertQryOrderDO.setAfsServiceId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            dycActDealAlertQryOrderDO.setAfsServiceIds(reqBO.getOrderIds());
        }
        List<String> orderIds = dycActOrderModel.qryAlertAfsOrderList(dycActDealAlertQryOrderDO);
        rspBO.setOrderIds(orderIds);
        return rspBO;
    }

    @Override
    public DycActQryAlertOrderListRspBO qryAlertAfsOrderList(DycActDealAlertQryOrderListReqBO reqBO) {
        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = new DycActDealAlertQryOrderDO();
        dycActDealAlertQryOrderDO.setAlertFlag(reqBO.getAlertFlag());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            dycActDealAlertQryOrderDO.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            dycActDealAlertQryOrderDO.setOrderIds(reqBO.getOrderIds());
        }
        List<ActAlertAfsOrderInfo> actAlertOrderInfos = dycActOrderModel.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
        DycActQryAlertOrderListRspBO rspBO = new DycActQryAlertOrderListRspBO();
        rspBO.setDycActAlertAfsOrderInfoBOS(JUtil.jsl(actAlertOrderInfos, DycActAlertAfsOrderInfoBO.class));
        return rspBO;
    }

    @Override
    public DycActDealAlertQryOrderListRspBO qryAlertFscOrderList(DycActDealAlertQryOrderListReqBO reqBO) {
        DycActDealAlertQryOrderListRspBO rspBO = new DycActDealAlertQryOrderListRspBO();
        DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO = new DycActDealAlertQryOrderDO();
        dycActDealAlertQryOrderDO.setAlertFlag(reqBO.getAlertFlag());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            dycActDealAlertQryOrderDO.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            dycActDealAlertQryOrderDO.setOrderIds(reqBO.getOrderIds());
        }
        dycActDealAlertQryOrderDO.setDayNum(reqBO.getDayNum());
        List<Long> orderIds = dycActFscOrderModel.qryAlertFscOrderList(dycActDealAlertQryOrderDO);
        rspBO.setFscOrderIds(orderIds);
        return rspBO;
    }
}
