package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.service.api.DycActDealAppApproveActivityService;
import com.tydic.dyc.act.service.bo.DycActDealAppApproveActivityReqBo;
import com.tydic.dyc.act.service.bo.DycActDealAppApproveActivityRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActDealAppApproveActivityServiceImpl
 * 说明：处理变更审批API实现类
 * 时间：2024/4/17 11:21 上午
 * 作者：汪成松
 */
@HTServiceImpl
public class DycActDealAppApproveActivityServiceImpl implements DycActDealAppApproveActivityService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActDealAppApproveActivityRspBo dealAppApprove(DycActDealAppApproveActivityReqBo reqBo) {
        DycActDealAppApproveActivityRspBo dycActDealAppApproveActivityRspBo = dycActivityChangeModel.dealAppApprove(reqBo);
        if (!BaseRspConstant.RSP_CODE_SUCCESS.equals(dycActDealAppApproveActivityRspBo.getRespCode())) {
            throw new BaseBusinessException(dycActDealAppApproveActivityRspBo.getRespCode(), dycActDealAppApproveActivityRspBo.getRespDesc());
        }
        return JSONObject.parseObject(JSONObject.toJSONString(dycActDealAppApproveActivityRspBo), DycActDealAppApproveActivityRspBo.class);
    }
}
