package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.service.api.DycActDealFscBillUploadService;
import com.tydic.dyc.act.service.bo.DycActDealFscBillUploadReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscBillUploadRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

/**
 * @ClassName DycActDealFscBillUploadServiceImpl
 * @Author 14051
 * @Date 2024/4/1 19:52
 * @Version 1.0
 * @Description 福利结算单对账单上传接口实现类
 **/
@HTServiceImpl
public class DycActDealFscBillUploadServiceImpl implements DycActDealFscBillUploadService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActDealFscBillUploadRspBO dealFscBillUpload(DycActDealFscBillUploadReqBO reqBO) {
        //todo 是否校验结算单是否存在？

        //查询是否已上传过对账单
        DycActivityFileInfo dycActivityFileInfo = new DycActivityFileInfo();
        dycActivityFileInfo.setObjId(reqBO.getFscOrderId());
        dycActivityFileInfo.setObjType(4);
        dycActivityFileInfo.setFileType(DycActivityConstants.FILE_TYPE.FILE_TYPE_BILL);
        DycActivityFileInfo dycActivityFileInfoP = dycActActivityModel.qryActFileInfo(dycActivityFileInfo);
        if (!ObjectUtils.isEmpty(dycActivityFileInfoP)){
            //删除已存在的附件对账单
            DycActivityFileInfo delActivityFileInfo = new DycActivityFileInfo();
            delActivityFileInfo.setObjId(reqBO.getFscOrderId());
            delActivityFileInfo.setObjType(4);
            delActivityFileInfo.setFileType(DycActivityConstants.FILE_TYPE.FILE_TYPE_BILL);
            dycActActivityModel.deleteActFileInfo(delActivityFileInfo);
        }
        //新增对账单附件
        DycActivityFileInfo addActivityFileInfo = new DycActivityFileInfo();
        addActivityFileInfo.setObjId(reqBO.getFscOrderId());
        addActivityFileInfo.setFileType(DycActivityConstants.FILE_TYPE.FILE_TYPE_BILL);
        addActivityFileInfo.setFileName(reqBO.getAttachmentName());
        addActivityFileInfo.setFileUrl(reqBO.getAttachmentUrl());
        //结算单
        addActivityFileInfo.setObjType(4);
        addActivityFileInfo.setDelFlag(0);
        dycActActivityModel.saveActFileInfo(addActivityFileInfo);
        return new DycActDealFscBillUploadRspBO();
    }
}
