package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.service.api.DycActDealFscConfirmPayService;
import com.tydic.dyc.act.service.bo.DycActDealFscConfirmPayReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscConfirmPayRspBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderInfoBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @ClassName DycActDealFscConfirmPayServiceImpl
 * @Author 14051
 * @Date 2024/4/2 20:20
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActDealFscConfirmPayServiceImpl implements DycActDealFscConfirmPayService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscConfirmPayRspBO dealFscOrderConfirmPay(DycActDealFscConfirmPayReqBO reqBO) {
        //校验结算单是否存在
        DycActFscOrderDO qryBO = new DycActFscOrderDO();
        qryBO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(qryBO);
        if (dycActFscOrderInfo == null){
            throw new ZTBusinessException("未查询到对应的结算单数据");
        }
        if (!DycActivityConstants.FSC_ORDER_STATE.SIGNED.equals(dycActFscOrderInfo.getOrderState())){
            throw new ZTBusinessException("当前结算单状态不是已收票，不能进行确认付款");
        }
        //更高结算单状态为已付款
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.PAYED);
        dycActFscOrderDO.setPayTime(new Date());
        dycActFscOrderDO.setPayUserId(reqBO.getUserId());
        dycActFscOrderDO.setPayUserName(reqBO.getName());
        dycActFscOrderModel.dealPayOrderState(dycActFscOrderDO);

        //处理预警,判断是否有超期未付款的预警，如果有，则将预警类型清空 并将预警记录表更新为已处理
        if (dycActFscOrderInfo.getAlertType() != null){
            if (DycActivityConstants.AlertType.UN_PAY.equals(dycActFscOrderInfo.getAlertType())){
                DycActFscOrderDO updFscOrdDo = new DycActFscOrderDO();
                updFscOrdDo.setFscOrderId(reqBO.getFscOrderId());
                updFscOrdDo.setAlertType(null);
                updFscOrdDo.setOldAlertType(DycActivityConstants.AlertType.UN_PAY);
                dycActFscOrderModel.dealUpdFscOrdAlertType(updFscOrdDo);
            }
        }
        DycActDealFscConfirmPayRspBO rspBo = new DycActDealFscConfirmPayRspBO();
        rspBo.setDycActFscOrderInfo(ActRu.js(dycActFscOrderInfo, DycActFscOrderInfoBO.class));
        return rspBo;
    }
}
