package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceItemDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.service.api.DycActDealFscGetInvoiceItemService;
import com.tydic.dyc.act.service.bo.DycActDealFscGetInvoiceItemReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscGetInvoiceItemRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @ClassName DycActDealFscGetInvoiceItemServiceImpl
 * @Author 14051
 * @Date 2024/4/7 19:56
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscGetInvoiceItemServiceImpl implements DycActDealFscGetInvoiceItemService {

    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscGetInvoiceItemRspBO dealFscGetInvoiceItem(DycActDealFscGetInvoiceItemReqBO reqBO) {
        //保存发票明细数据
        DycActFscInvoiceItemDO dycActFscInvoiceItemDO = new DycActFscInvoiceItemDO();
        dycActFscInvoiceItemDO = JUtil.js(reqBO, DycActFscInvoiceItemDO.class);
        dycActFscInvoiceModel.saveFscInvoiceItem(dycActFscInvoiceItemDO);
        //更新已获取明细标识
        dycActFscInvoiceModel.updateFscInvoiceFlag(dycActFscInvoiceItemDO);
        //判断是否所有发票都获取了明细，如果是则更新成已开票
        dycActFscInvoiceItemDO = new DycActFscInvoiceItemDO();
        dycActFscInvoiceItemDO.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.NO);
        dycActFscInvoiceItemDO.setFscOrderId(reqBO.getFscOrderId());
        int num = dycActFscInvoiceModel.getCountUnGetItem(dycActFscInvoiceItemDO);
        if (num == 0){
            DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
            dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.INVOICED);
            dycActFscOrderDO.setUpdateTime(new Date());
            dycActFscOrderDO.setBillTime(new Date());
            dycActFscOrderModel.dealFscOrderState(dycActFscOrderDO);
        }
        return new DycActDealFscGetInvoiceItemRspBO();
    }
}
