package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceListInfo;
import com.tydic.dyc.act.service.api.DycActDealFscGetInvoiceService;
import com.tydic.dyc.act.service.bo.DycActDealFscGetInvoiceReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscGetInvoiceRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @ClassName DycActDealFscGetInvoiceServiceImpl
 * @Author 14051
 * @Date 2024/4/7 11:46
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscGetInvoiceServiceImpl implements DycActDealFscGetInvoiceService {

    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;

    @Override
    public DycActDealFscGetInvoiceRspBO dealFscGetInvoice(DycActDealFscGetInvoiceReqBO reqBO) {
        //保存发票信息
        if (reqBO.getFscOrderId() == null){
            throw new ZTBusinessException("结算单ID为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getInvoiceList())){
            throw new ZTBusinessException("结算单发票集合为空！");
        }
        DycActFscInvoiceDO actFscInvoiceDO = JUtil.js(reqBO, DycActFscInvoiceDO.class);
        actFscInvoiceDO.setDycActFscInvoiceListInfos(JUtil.jsl(reqBO.getInvoiceList(), DycActFscInvoiceListInfo.class));
        dycActFscInvoiceModel.saveFscInvoices(actFscInvoiceDO);

        return new DycActDealFscGetInvoiceRspBO();
    }
}
