package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActDealFscOrderCancelService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderCancelReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderCancelRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName DycActDealFscOrderCancelServiceImpl
 * @Author 14051
 * @Date 2024/4/8 10:29
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscOrderCancelServiceImpl implements DycActDealFscOrderCancelService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActDealFscOrderCancelRspBO dealFscOrderCancel(DycActDealFscOrderCancelReqBO reqBO) {
        if (reqBO.getFscOrderId() == null){
            throw new ZTBusinessException("结算单ID不能为空");
        }
        //更改结算单状态
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setCancelReason("主动取消");
        dycActFscOrderDO.setCancelUserId(reqBO.getUserId().toString());
        dycActFscOrderDO.setCancelUserName(reqBO.getName());
        dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.CANCELED);
        dycActFscOrderModel.dealFscOrderState(dycActFscOrderDO);

        //处理结算单和订单关系表
        DycActFscOrderDO cancelDO = new DycActFscOrderDO();
        cancelDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderModel.dealFscOrdRelationCancel(cancelDO);

        //删除批次明细表
        dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderModel.deleteFscOrderBatchInfo(dycActFscOrderDO);

        //更新活动表上的已结算标识为未结算
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setIsSettleFlag(Integer.parseInt(DycActivityConstants.Settle_Flag.Settle_Flag_ZERO));
        dycActActivityModel.updateActivityState(dycActivityDO);

        //todo 记录操作历史

        return new DycActDealFscOrderCancelRspBO();
    }
}
