package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrdSaveInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderSaveDO;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActCodeGenerationService;
import com.tydic.dyc.act.service.api.DycActDealFscOrderCreateService;
import com.tydic.dyc.act.service.bo.DycActCodeGenerationReqBO;
import com.tydic.dyc.act.service.bo.DycActCodeGenerationRspBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderCreateReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderCreateRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @ClassName DycActDealFscOrderCreateServiceImpl
 * @Author 14051
 * @Date 2024/4/8 15:14
 * @Version 1.0
 **/
@Slf4j
@HTServiceImpl
public class DycActDealFscOrderCreateServiceImpl implements DycActDealFscOrderCreateService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActCodeGenerationService dycActCodeGenerationService;

    @Override
    public DycActDealFscOrderCreateRspBO dealFscOrderCreate(DycActDealFscOrderCreateReqBO reqBO) {
        //生成结算单
        DycActFscOrderSaveDO dycActFscOrderSaveDO = JUtil.js(reqBO, DycActFscOrderSaveDO.class);
        if (reqBO.getMakeType() == null){
            dycActFscOrderSaveDO.setMakeType(DycActivityConstants.MakeType.ECOM);
        }
        dycActFscOrderSaveDO.setOrderNo(getFscOrderNo());
        dycActFscOrderSaveDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.COMMITED);
        dycActFscOrderSaveDO.setCreateTime(new Date());
        DycActFscOrdSaveInfo dycActFscOrdSaveInfo = dycActFscOrderModel.saveFscOrder(dycActFscOrderSaveDO);

        //更改活动结算标识为已结算
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setIsSettleFlag(Integer.parseInt(DycActivityConstants.Settle_Flag.Settle_Flag_ONE));
        dycActActivityModel.updateActivityState(dycActivityDO);

        //todo 记录日志

        DycActDealFscOrderCreateRspBO rspBO = new DycActDealFscOrderCreateRspBO();
        rspBO.setFscOrderId(dycActFscOrdSaveInfo.getFscOrderId());
        return rspBO;
    }

    /**
     * 获取编号
     * @return
     */
    private String getFscOrderNo(){
        DycActCodeGenerationReqBO dycActCodeGenerationReqBO = new DycActCodeGenerationReqBO();
        dycActCodeGenerationReqBO.setCenter("FSC");
        dycActCodeGenerationReqBO.setCode("MATCH_MODEL_PURCHASE_ORDER_NO_4");
        dycActCodeGenerationReqBO.setCount(1);
        DycActCodeGenerationRspBO dycActCodeGenerationRspBO = dycActCodeGenerationService.dealCodeGeneration(dycActCodeGenerationReqBO);
        if (dycActCodeGenerationRspBO == null || !DycActivityRspConstants.RESP_CODE_SUCCESS.equals(dycActCodeGenerationRspBO.getRespCode())){
            throw new ZTBusinessException("获取结算单编号异常");
        }
        return dycActCodeGenerationRspBO.getCodeList().get(0);
    }
}
