package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderLogisticsInfoDO;
import com.tydic.dyc.act.service.api.DycActDealFscOrderMailInfoService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderMailInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderMailInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName DycActDealFscOrderMailInfoServiceImpl
 * @Author 14051
 * @Date 2024/4/7 10:12
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscOrderMailInfoServiceImpl implements DycActDealFscOrderMailInfoService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscOrderMailInfoRspBO dealFscOrderMailInfo(DycActDealFscOrderMailInfoReqBO reqBO) {
        if (reqBO.getFscOrderId() == null){
            throw new ZTBusinessException("结算单ID不能为空");
        }
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(dycActFscOrderDO);
        if (dycActFscOrderInfo == null){
            throw new ZTBusinessException("未查询到结算单数据");
        }

        DycActFscOrderLogisticsInfoDO dycActFscOrderLogisticsInfoDO = new DycActFscOrderLogisticsInfoDO();
        dycActFscOrderLogisticsInfoDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderLogisticsInfoDO.setLogisticsOrder(reqBO.getLogisticsOrder());
        dycActFscOrderLogisticsInfoDO.setLogisticsCompany(reqBO.getLogisticsCompany());
        dycActFscOrderModel.updateFscOrderLogisticsInfo(dycActFscOrderLogisticsInfoDO);

        return new DycActDealFscOrderMailInfoRspBO();
    }
}
