package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActDealFscOrderRejectService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderRejectReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderRejectRspBO;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityUserInfoReqBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.Date;

/**
 * @ClassName DycActDealFscOrderRejectServiceImpl
 * @Author 14051
 * @Date 2024/4/6 14:48
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscOrderRejectServiceImpl implements DycActDealFscOrderRejectService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscOrderRejectRspBO dealFscOrderReject(DycActDealFscOrderRejectReqBO reqBO) {
        //入参校验
        checkParam(reqBO);
        DycActFscOrderDO dycActFscOrderQryDO = new DycActFscOrderDO();
        dycActFscOrderQryDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(dycActFscOrderQryDO);
        if (dycActFscOrderInfo == null){
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"结算单信息查询为空");
        }
        if(!DycActivityConstants.FSC_ORDER_STATE.INVOICING.equals(dycActFscOrderInfo.getOrderState())){
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"驳回失败，结算单状态不为开票中");
        }
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.REJECT);
        dycActFscOrderDO.setUpdateTime(new Date());
        dycActFscOrderDO.setOrderDesc(reqBO.getRejectReason());
        dycActFscOrderModel.dealFscOrderReject(dycActFscOrderDO);

        DycActDealFscOrderRejectRspBO rspBo = JSON.parseObject(JSON.toJSONString(dycActFscOrderInfo), DycActDealFscOrderRejectRspBO.class);
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    public void checkParam(DycActDealFscOrderRejectReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"入参不能为空");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"结算单ID不能为空");
        }
    }
}
