package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.service.api.DycActDealFscOrderStateUpdService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderStateUpdReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderStateUpdRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @ClassName DycActDealFscOrderStateUpdServiceImpl
 * @Author 14051
 * @Date 2024/4/18 11:02
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActDealFscOrderStateUpdServiceImpl implements DycActDealFscOrderStateUpdService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscOrderStateUpdRspBO dealFscOrderStateUpd(DycActDealFscOrderStateUpdReqBO reqBO) {
        if ("1".equals(reqBO.getDealFlag())) {
            //判断提交电商是否全部成功
            DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
            dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
            int failCount = dycActFscOrderModel.getFscPushFailNum(dycActFscOrderDO);
            if (failCount == 0) {
                dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.INVOICING);
                dycActFscOrderDO.setUpdateTime(new Date());
                dycActFscOrderModel.dealFscOrderState(dycActFscOrderDO);
            }
        } else {
            //直接根据参数处理状态更新
            DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
            dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderDO.setOrderState(reqBO.getOrderState());
            dycActFscOrderDO.setUpdateTime(new Date());
            dycActFscOrderDO.setUpdateUserId(reqBO.getUserId());
            dycActFscOrderDO.setUpdateUserName(reqBO.getName());
            dycActFscOrderModel.dealFscOrderState(dycActFscOrderDO);
        }
        return new DycActDealFscOrderStateUpdRspBO();
    }
}
