package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActDealFscSignCheckService;
import com.tydic.dyc.act.service.bo.DycActDealFscSignCheckReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscSignCheckRspBO;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceBO;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceCmpResultBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;

/**
 * @ClassName DycActDealFscSignCheckServiceImpl
 * @Author 14051
 * @Date 2024/4/6 15:15
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActDealFscSignCheckServiceImpl implements DycActDealFscSignCheckService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;
    /**
     * 不匹配
     */
    private static final String MISMATCHING = "000000";

    @Override
    public DycActDealFscSignCheckRspBO dealFscOrderSignCheck(DycActDealFscSignCheckReqBO reqBO) {
        DycActDealFscSignCheckRspBO rspBO = new DycActDealFscSignCheckRspBO();
        //查询基本信息
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(dycActFscOrderDO);
        if(null == dycActFscOrderInfo){
            throw new ZTBusinessException("查询结算单数据为空");
        }
        if(!DycActivityConstants.FSC_ORDER_STATE.INVOICED.equals(dycActFscOrderInfo.getOrderState())){
            throw new ZTBusinessException("只有已开票状态才可核对发票");
        }
        rspBO = JUtil.js(dycActFscOrderInfo, DycActDealFscSignCheckRspBO.class);
        //待开票发票信息
        DycActFscOrderDO fscOrderInvoiceDO = new DycActFscOrderDO();
        fscOrderInvoiceDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInvoiceInfo dycActFscOrderInvoiceInfo = dycActFscOrderModel.selectOneFscOrderInvoice(fscOrderInvoiceDO);
        if(null != dycActFscOrderInvoiceInfo){
            DycActFscInvoiceBO preInvoiceBO = JSON.parseObject(JSON.toJSONString(dycActFscOrderInvoiceInfo), DycActFscInvoiceBO.class);
            preInvoiceBO.setAmt(dycActFscOrderInfo.getTotalCharge());
            rspBO.setPreInvoice(preInvoiceBO);
        }
        //发票信息
        DycActFscInvoiceDO fscInvoiceDO = new DycActFscInvoiceDO();
        fscInvoiceDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscInvoiceInfo dycActFscInvoiceInfo = dycActFscInvoiceModel.getSumAmtByFscOrderId(fscInvoiceDO);
        if(null != dycActFscInvoiceInfo){
            DycActFscInvoiceBO afterInvoiceBO = JSON.parseObject(JSON.toJSONString(dycActFscInvoiceInfo), DycActFscInvoiceBO.class);
            rspBO.setAfterInvoice(afterInvoiceBO);
        }
        //比对结果
        cmpResult(rspBO);

        return rspBO;
    }

    private void cmpResult(DycActDealFscSignCheckRspBO rspBO){
        DycActFscInvoiceCmpResultBO invoiceCmpResultBO = new DycActFscInvoiceCmpResultBO();
        if(null == rspBO.getPreInvoice() || null == rspBO.getAfterInvoice()){
            invoiceCmpResultBO.setCmpResultStr(MISMATCHING);
            DycActFscInvoiceBO invoiceBO = null;
            if(null != rspBO.getPreInvoice()){
                invoiceBO = rspBO.getPreInvoice();
            }
            if(null != rspBO.getAfterInvoice()){
                invoiceBO = rspBO.getAfterInvoice();
            }
            if (null != invoiceBO) {
                invoiceCmpResultBO.setUntaxAmtMargin(invoiceBO.getUntaxAmt());
                invoiceCmpResultBO.setTaxMargin(invoiceBO.getTaxAmt());
                invoiceCmpResultBO.setAmountMargin(invoiceBO.getAmt());
            }
        } else {
            StringBuilder cmpResultStr = new StringBuilder();
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getBuyName(), rspBO.getAfterInvoice().getBuyName()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getTaxNo(), rspBO.getAfterInvoice().getTaxNo()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getAddress(), rspBO.getAfterInvoice().getAddress()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getPhone(), rspBO.getAfterInvoice().getPhone()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getBank(), rspBO.getAfterInvoice().getBank()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getAccount(), rspBO.getAfterInvoice().getAccount()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getAmt(), rspBO.getAfterInvoice().getAmt()));
            //不比对税额和不含税金额
            /*cmpResultStr.append(checkParam(rspBO.getPreInvoice().getTaxAmt(), rspBO.getAfterInvoice().getTaxAmt()));
            cmpResultStr.append(checkParam(rspBO.getPreInvoice().getUntaxAmt(), rspBO.getAfterInvoice().getUntaxAmt()));*/
            invoiceCmpResultBO.setCmpResultStr(cmpResultStr.toString());
            BigDecimal preAmt = null == rspBO.getPreInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getAmt();
            BigDecimal afterAmt = null == rspBO.getAfterInvoice().getAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getAmt();
            invoiceCmpResultBO.setAmountMargin(subtract(preAmt, afterAmt));
            /*BigDecimal preTaxAmt = null == rspBO.getPreInvoice().getTaxAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getTaxAmt();
            BigDecimal afterTaxAmt = null == rspBO.getAfterInvoice().getTaxAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getTaxAmt();
            invoiceCmpResultBO.setTaxMargin(subtract(preTaxAmt, afterTaxAmt));
            BigDecimal preUntaxAmt = null == rspBO.getPreInvoice().getUntaxAmt() ? BigDecimal.ZERO : rspBO.getPreInvoice().getUntaxAmt();
            BigDecimal afterUntaxAmt = null == rspBO.getAfterInvoice().getUntaxAmt() ? BigDecimal.ZERO : rspBO.getAfterInvoice().getUntaxAmt();
            invoiceCmpResultBO.setUntaxAmtMargin(subtract(preUntaxAmt, afterUntaxAmt));*/
        }
        rspBO.setInvoiceCmpResult(invoiceCmpResultBO);
    }

    private int checkParam(Object param1, Object param2){
        int isMatch = DycActivityConstants.FscInvoiceVerifyResult.NO;
        if (param1 instanceof String) {
            String pstr1 = (String)param1;
            String pstr2 = (String)param2;
            if (StringUtils.isBlank(pstr1) && StringUtils.isBlank(pstr2)) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
            if (!StringUtils.isBlank(pstr1) && !StringUtils.isBlank(pstr2) && param1.equals(param2)) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
        }
        if(param1 instanceof BigDecimal){
            BigDecimal bstr1 = (BigDecimal)param1;
            BigDecimal bstr2 = (BigDecimal)param2;
            if (null != bstr1 && null != bstr2 && bstr1.compareTo(bstr2) == 0) {
                isMatch = DycActivityConstants.FscInvoiceVerifyResult.YES;
            }
        }
        return isMatch;
    }

    /**
     * 解决结果等于零时，浮点数过长导致的异常值
     * @param minuend 被减数
     * @param subtrahend 减数
     * @return 结果
     */
    private BigDecimal subtract(BigDecimal minuend, BigDecimal subtrahend) {
        BigDecimal result = minuend.subtract(subtrahend);
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return result.abs();
    }
}
