package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderSignDO;
import com.tydic.dyc.act.service.api.DycActDealFscSignService;
import com.tydic.dyc.act.service.bo.DycActDealFscSignReqBO;
import com.tydic.dyc.act.service.bo.DycActDealFscSignRspBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActQryActivityUserInfoPageListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * @ClassName DycActDealFscSignServiceImpl
 * @Author 14051
 * @Date 2024/4/2 20:58
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActDealFscSignServiceImpl implements DycActDealFscSignService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActDealFscSignRspBO dealFscOrderSign(DycActDealFscSignReqBO reqBO) {
        //校验结算单是否存在
        DycActFscOrderDO qryBO = new DycActFscOrderDO();
        qryBO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(qryBO);
        if (dycActFscOrderInfo == null){
            throw new ZTBusinessException("未查询到对应的结算单数据");
        }
        if (!DycActivityConstants.FSC_ORDER_STATE.INVOICED.equals(dycActFscOrderInfo.getOrderState())){
            throw new ZTBusinessException("当前结算单状态不是已开票，不能进行签收");
        }
        //更高结算单状态为已收票
        DycActFscOrderSignDO dycActFscOrderDO = new DycActFscOrderSignDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderDO.setOrderState(DycActivityConstants.FSC_ORDER_STATE.SIGNED);
        dycActFscOrderDO.setSignTime(new Date());
        dycActFscOrderDO.setSignOperId(reqBO.getUserId());
        dycActFscOrderDO.setSignOperName(reqBO.getName());
        dycActFscOrderModel.dealSignOrderState(dycActFscOrderDO);

        //处理预警,判断是否有超期未签收的预警，如果有，则将预警类型清空 并将预警记录表更新为已处理

        if (dycActFscOrderInfo.getAlertType() != null){
            if (DycActivityConstants.AlertType.UN_SIGN.equals(dycActFscOrderInfo.getAlertType())){
                DycActFscOrderDO updFscOrdDo = new DycActFscOrderDO();
                updFscOrdDo.setFscOrderId(reqBO.getFscOrderId());
                updFscOrdDo.setAlertType(null);
                updFscOrdDo.setOldAlertType(DycActivityConstants.AlertType.UN_SIGN);
                dycActFscOrderModel.dealUpdFscOrdAlertType(updFscOrdDo);
            }
        }
        DycActDealFscSignRspBO dycActDealFscSignRspBo = new DycActDealFscSignRspBO();
        dycActDealFscSignRspBo.setDycActFscOrderInfo(ActRu.js(dycActFscOrderInfo, DycActFscOrderInfoBO.class));
        return  dycActDealFscSignRspBo;
    }
}
