package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActDealScoreExceedsLimitService;
import com.tydic.dyc.act.service.bo.DycActDealScoreExceedsLimitReqBo;
import com.tydic.dyc.act.service.bo.DycActDealScoreExceedsLimitRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActDealScoreExceedsLimitServiceImpl
 * 说明：活动变更-积分发放超额提醒API实现类
 * 时间：2024/4/16 3:28 下午
 * 作者：汪成松
 */
@HTServiceImpl
public class DycActDealScoreExceedsLimitServiceImpl implements DycActDealScoreExceedsLimitService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActDealScoreExceedsLimitRspBo dealScoreExceedsLimit(DycActDealScoreExceedsLimitReqBo reqBo) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        DycActivityChangeDO dycActivityChangeDoModel = dycActivityChangeModel.qryUserInfoLimitScore(dycActivityChangeDo);
        DycActDealScoreExceedsLimitRspBo dycActDealScoreExceedsLimitRspBo = JSONObject.parseObject(JSONObject.toJSONString(dycActivityChangeDoModel), DycActDealScoreExceedsLimitRspBo.class);
        dycActDealScoreExceedsLimitRspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        dycActDealScoreExceedsLimitRspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return dycActDealScoreExceedsLimitRspBo;
    }
}
