package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActDeductOrReturnActivityScoresService;
import com.tydic.dyc.act.service.bo.DycActDeductOrReturnActivityScoresReqBO;
import com.tydic.dyc.act.service.bo.DycActDeductOrReturnActivityScoresRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动积分扣减/退还服务
 *
 * @author zhoulu
 * @date 2023年12月27日 17:21
 */
@HTServiceImpl
public class DycActDeductOrReturnActivityScoresServiceImpl implements DycActDeductOrReturnActivityScoresService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActDeductOrReturnActivityScoresRspBO deductOrReturnActivityScores(DycActDeductOrReturnActivityScoresReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setActUserId(reqBO.getUseUserId());
        dycActActivityModel.deductOrReturnActivityScores(dycActivityDO);
        DycActDeductOrReturnActivityScoresRspBO rspBO = new DycActDeductOrReturnActivityScoresRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
