package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.service.api.DycActDelEmptyActivityCommodityCatalogService;
import com.tydic.dyc.act.service.bo.ActDelEmptyActivityCommodityCatalogCatalogReqBO;
import com.tydic.dyc.act.service.bo.ActDelEmptyActivityCommodityCatalogRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

import java.util.Date;

/**
 * 标题：DycActDelEmptyActivityCommodityCatalogServiceImpl
 * 说明：无
 * 时间：2024/4/17
 *
 * @author zhoujie
 */
@HTServiceImpl
public class DycActDelEmptyActivityCommodityCatalogServiceImpl implements DycActDelEmptyActivityCommodityCatalogService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public ActDelEmptyActivityCommodityCatalogRspBO delEmptyActivityCommodityCatalog(ActDelEmptyActivityCommodityCatalogCatalogReqBO reqBo) {
        //入参校验
        this.verifyParam(reqBo);
        ActDelEmptyActivityCommodityCatalogRspBO rspBo = new ActDelEmptyActivityCommodityCatalogRspBO();

        DycActiveCommodityCatalogInfo dycActiveCommodityCatalogInfo = new DycActiveCommodityCatalogInfo();
        dycActiveCommodityCatalogInfo.setUpdateUserId(reqBo.getUserId());
        dycActiveCommodityCatalogInfo.setUpdateUserName(reqBo.getName());
        dycActiveCommodityCatalogInfo.setUpdateTime(new Date());
        dycActiveCommodityCatalogInfo.setActivityId(reqBo.getActivityId());
        dycActiveCommodityCatalogInfo.setDelFlag(1);
        try {
            int i = dycActActivityModel.delEmptyActivityCommodityCatalog(dycActiveCommodityCatalogInfo);
        }catch (Exception e){
            e.printStackTrace();
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "清空商品类型失败");
        }
        return rspBo;
    }

    /**
     * 参数校验
     */
    private void verifyParam(ActDelEmptyActivityCommodityCatalogCatalogReqBO reqBo) {
        if (ObjectUtils.isEmpty(reqBo)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getActivityId() == null) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR, "入参[活动id]不能为空");
        }
    }
}
