package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActDeleteLaborUnionService;
import com.tydic.dyc.act.service.bo.DycActDeleteLaborUnionReqBO;
import com.tydic.dyc.act.service.bo.DycActDeleteLaborUnionRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 标题：DycActDeleteLaborUnionServiceImpl
 * 说明：
 * 时间： 2024-03-27 14:07
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActDeleteLaborUnionServiceImpl implements DycActDeleteLaborUnionService {

    @Autowired
    private DycActIaborModel dycActIaborModel;
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActDeleteLaborUnionRspBO deleteLaborUnion(DycActDeleteLaborUnionReqBO reqBO) {
        checkParam(reqBO);

        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityScopeOrgId(reqBO.getLaborUnionId());
        List<DycActivityBaseInfo> baseInfos = dycActActivityModel.queryActivityList(activityDO);
        for (DycActivityBaseInfo dycActivityDO : baseInfos){
            if(!(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN.equals(dycActivityDO.getActivityState())
                    && DycActivityConstants.Settle_Flag.Settle_Flag_ONE.equals(dycActivityDO.getIsSettleFlag()))){
                throw new ZTBusinessException("当前工会存在活动中，不允许删除！");
            }
        }

        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        dycActIaborModel.deleteLaborUnion(dycActivityDO);
        DycActDeleteLaborUnionRspBO rspBO = new DycActDeleteLaborUnionRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActDeleteLaborUnionReqBO reqBO){
        if(ObjectUtils.isEmpty(reqBO)){
            throw new ZTBusinessException("参数为空！");
        }
        if(null == reqBO.getLaborUnionId()){
            throw new ZTBusinessException("工会id为空！");
        }
    }
}
