package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.service.api.DycActDeleteSkuPoolService;
import com.tydic.dyc.act.service.bo.DycActDeleteSkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActDeleteSkuPoolRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： DycActDeleteSkuPoolServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/16 19:56
 */
@HTServiceImpl
public class DycActDeleteSkuPoolServiceImpl implements DycActDeleteSkuPoolService {

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @Override
    public DycActDeleteSkuPoolRspBO deleteSkuPool(DycActDeleteSkuPoolReqBO reqBO) {
        this.valData(reqBO);
        // 删除商品池
        ActSkuPoolReqBO poolReqBO = new ActSkuPoolReqBO();
        poolReqBO.setPoolId(reqBO.getPoolId());
        dycActSkuPoolModel.deleteActSkuPool(poolReqBO);

        // 删除商品池关联商品表
        ActRelSkuPoolReqBO relSkuPoolReqBO = new ActRelSkuPoolReqBO();
        relSkuPoolReqBO.setPoolId(reqBO.getPoolId());
        dycActSkuPoolModel.batchDeleteActRelSkuPool(relSkuPoolReqBO);

        // 删除商品池关联业务表
        ActRelSourcePoolReqBO relSourcePoolReqBO = new ActRelSourcePoolReqBO();
        relSourcePoolReqBO.setPoolId(reqBO.getPoolId());
        dycActSkuPoolModel.batchDeleteActRelSourcePool(relSourcePoolReqBO);
        return ActRu.success(DycActDeleteSkuPoolRspBO.class);
    }

    private void valData(DycActDeleteSkuPoolReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池删除服务入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPoolId())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池删除服务入参商品池ID[poolId]为空");
        }
    }
}
