package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderBatchInfoDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderRelationInfo;
import com.tydic.dyc.act.service.api.DycActFscOrderRelationQryListService;
import com.tydic.dyc.act.service.bo.DycActFscOrderRelationQryListReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderRelationQryListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActFscOrderRelationQryListServiceImpl
 * @Author 14051
 * @Date 2024/4/9 10:22
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActFscOrderRelationQryListServiceImpl implements DycActFscOrderRelationQryListService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActFscOrderRelationQryListRspBO qryOrderRelationList(DycActFscOrderRelationQryListReqBO reqBO) {
        DycActFscOrderRelationQryListRspBO rspBO = new DycActFscOrderRelationQryListRspBO();
        DycActFscOrderBatchInfoDO dycActFscOrderBatchInfoDO = new DycActFscOrderBatchInfoDO();
        dycActFscOrderBatchInfoDO.setFscOrderId(reqBO.getFscOrderId());
        dycActFscOrderBatchInfoDO.setBatchId(reqBO.getBatchId());
        List<DycActFscOrderRelationInfo> dycActFscOrderRelationInfos = dycActFscOrderModel.getFscOrdRelationList(dycActFscOrderBatchInfoDO);
        if (!CollectionUtils.isEmpty(dycActFscOrderRelationInfos)){
            rspBO.setOrderIds(dycActFscOrderRelationInfos.stream().map(DycActFscOrderRelationInfo::getOrderId).collect(Collectors.toList()));
        }

        //统计当前批次总金额
        BigDecimal currentAmt = dycActFscOrderModel.getCurrentAmt(dycActFscOrderBatchInfoDO);
        rspBO.setBatchAmt(currentAmt);
        return rspBO;
    }
}
