package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActFscOrderSubmitInvoiceSplitService;
import com.tydic.dyc.act.service.bo.DycActFscDealOrderSubmitInvoiceResultRspBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderBatchInfoBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActFscOrderSubmitInvoiceSplitServiceImpl
 * @Author 14051
 * @Date 2024/4/8 18:07
 * @Version 1.0
 **/
@Slf4j
@HTServiceImpl
public class DycActFscOrderSubmitInvoiceSplitServiceImpl implements DycActFscOrderSubmitInvoiceSplitService {
    /**
     * 结算单推送电商拆分数量
     */
    @Value("${ACT_FSC_ORDER_SPLIT_NUM:300}")
    private int splitNum;
    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActFscOrderSubmitInvoiceSplitRspBO dealfscOrderSplit(DycActFscOrderSubmitInvoiceSplitReqBO reqBO) {
        //计算总批次号
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(reqBO.getFscOrderId());
        int orderNum = dycActFscOrderModel.getFscOrderNum(dycActFscOrderDO);
        int totalBatch = (orderNum % splitNum == 0) ? orderNum/splitNum : orderNum/splitNum + 1;
        log.info("totalBatch=====================:{}", totalBatch);
        List<DycActFscOrderBatchInfoBO> batchInfoList = new ArrayList<>();

        int batchId = 0;
        while (true){
            batchId++ ;
            log.info("当前batchId={}", batchId);
            DycActFscOrderQryDO dycActFscOrderQryDO = new DycActFscOrderQryDO();
            dycActFscOrderQryDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderQryDO.setPageNo(totalBatch);
            dycActFscOrderQryDO.setPageSize(splitNum);
            BasePageRspBo<DycActFscOrderRelationInfo> dycActFscOrderRelationInfoBasePageRspBo = dycActFscOrderModel.getFscOrderRelationList(dycActFscOrderQryDO);
            //没有数据则退出循环
            if (CollectionUtils.isEmpty(dycActFscOrderRelationInfoBasePageRspBo.getRows())) {
                break;
            }
            //更新批次号
            DycActFscOrderRelationDO dycActFscOrderRelationDO = new DycActFscOrderRelationDO();
            dycActFscOrderRelationDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderRelationDO.setBatchId(totalBatch);
            dycActFscOrderRelationDO.setOrderIds(dycActFscOrderRelationInfoBasePageRspBo.getRows().stream().map(DycActFscOrderRelationInfo::getOrderId).collect(Collectors.toList()));
            dycActFscOrderModel.updateRelationBatch(dycActFscOrderRelationDO);

            //插入当前批次信息
            DycActFscOrderBatchInfoDO dycActFscOrderBatchInfoDO = new DycActFscOrderBatchInfoDO();
            dycActFscOrderBatchInfoDO.setId(Sequence.getInstance().nextId());
            dycActFscOrderBatchInfoDO.setTotalBatch(totalBatch);
            dycActFscOrderBatchInfoDO.setFscOrderId(reqBO.getFscOrderId());
            dycActFscOrderBatchInfoDO.setPushResult(DycActivityConstants.PushResult.UN_PUSH);
            dycActFscOrderBatchInfoDO.setBatchId(batchId);
            dycActFscOrderBatchInfoDO.setCreateTime(new Date());
            dycActFscOrderModel.saveBatchInfo(dycActFscOrderBatchInfoDO);

            batchInfoList.add(JUtil.js(dycActFscOrderBatchInfoDO, DycActFscOrderBatchInfoBO.class));
            if (batchId == totalBatch){
                break;
            }
        }

        DycActFscOrderSubmitInvoiceSplitRspBO rspBO = new DycActFscOrderSubmitInvoiceSplitRspBO();
        rspBO.setBatchInfoList(batchInfoList);
        return rspBO;
    }

    @Override
    public DycActFscDealOrderSubmitInvoiceResultRspBO dealSubmitResult(DycActFscOrderSubmitInvoiceSplitReqBO reqBO) {
        DycActFscOrderBatchInfoDO dycActFscOrderBatchInfoDO = JUtil.js(reqBO, DycActFscOrderBatchInfoDO.class);
        dycActFscOrderBatchInfoDO.setPushTime(new Date());
        dycActFscOrderModel.updateBatchInfo(dycActFscOrderBatchInfoDO);
        return new DycActFscDealOrderSubmitInvoiceResultRspBO();
    }
}
