package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderQryDO;
import com.tydic.dyc.act.service.api.DycActGetFscOrderWarningService;
import com.tydic.dyc.act.service.bo.DycActFscOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActGetFscOrderWarningReqBO;
import com.tydic.dyc.act.service.bo.DycActGetFscOrderWarningRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 DycActGetFscOrderWarningServiceImpl
 * 说明 获取预警结算单
 * 时间 2024/4/24 14:56
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActGetFscOrderWarningServiceImpl implements DycActGetFscOrderWarningService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Override
    public DycActGetFscOrderWarningRspBO getFscOrderWarning(DycActGetFscOrderWarningReqBO reqBO) {
        DycActFscOrderQryDO dycActFscOrderQryDO = ActRu.js(reqBO, DycActFscOrderQryDO.class);
        List<DycActFscOrderDO> fscOrderWarning = dycActFscOrderModel.getFscOrderWarning(dycActFscOrderQryDO);
        DycActGetFscOrderWarningRspBO rspBO = new DycActGetFscOrderWarningRspBO();
        rspBO.setList(ActRu.jsl(fscOrderWarning, DycActFscOrderInfoBO.class));
        return rspBO;
    }
}
