package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeCommodityModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityChangeCommodityModelRspBO;
import com.tydic.dyc.act.service.api.DycActImportActivityChangeCommodityService;
import com.tydic.dyc.act.service.bo.DycActImportActivityChangeCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActImportActivityChangeCommodityRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题 DycActImportActivityChangeCommodityServiceImpl
 * 说明 活动变更商品导入
 * 时间 2024/4/16 20:46
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActImportActivityChangeCommodityServiceImpl implements DycActImportActivityChangeCommodityService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;
    @Override
    public DycActImportActivityChangeCommodityRspBO importActivityChangeCommodity(DycActImportActivityChangeCommodityReqBO reqBO) {
        DycActImportActivityChangeCommodityModelReqBO dycActImportActivityChangeCommodityModelReqBO = ActRu.js(reqBO,DycActImportActivityChangeCommodityModelReqBO.class);
        DycActImportActivityChangeCommodityModelRspBO rspBO = dycActivityChangeModel.importActivityChangeCommodity(dycActImportActivityChangeCommodityModelReqBO);
        return ActRu.js(rspBO,DycActImportActivityChangeCommodityRspBO.class);
    }
}
