package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityModelRspBO;
import com.tydic.dyc.act.service.api.DycActImportActivityCommodityService;
import com.tydic.dyc.act.service.bo.DycActImportActivityCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActImportActivityCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActImportActivityCommodityServiceImpl
 * 说明：
 * 时间： 2024-04-07 11:05
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActImportActivityCommodityServiceImpl implements DycActImportActivityCommodityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;


    @Override
    public DycActImportActivityCommodityRspBO importActivityCommodity(DycActImportActivityCommodityReqBO reqBO) {
        DycActImportActivityCommodityModelReqBO commodityModelReqBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActImportActivityCommodityModelReqBO.class);
        DycActImportActivityCommodityModelRspBO modelRspBO = dycActActivityModel.importActivityCommodity(commodityModelReqBO);
        return JSON.parseObject(JSON.toJSONString(modelRspBO), DycActImportActivityCommodityRspBO.class);
    }
}
