package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.act.repository.api.DycActSkuGuideRepository;
import com.tydic.dyc.act.service.api.DycActInitialDataTemplateImportAbilityService;
import com.tydic.dyc.act.service.bo.DycActInitialDataTemplateImportAbilityReqBO;
import com.tydic.dyc.act.service.bo.DycActInitialDataTemplateImportAbilityRspBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogListBO;
import com.tydic.dyc.act.utils.ExcelNewUtils;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 标题：UccInitialDataTemplateImportAbilityServiceImpl
 * 说明：
 * 时间：2024/1/17 9:43
 * 作者：Zhouhaifeng
 */
@HTServiceImpl
@Slf4j
public class DycActInitialDataTemplateImportAbilityServiceImpl implements DycActInitialDataTemplateImportAbilityService {

    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;

    @Autowired
    private FileClient fileClient;
    @Override
    public DycActInitialDataTemplateImportAbilityRspBO importData(DycActInitialDataTemplateImportAbilityReqBO reqBO) {
        DycActInitialDataTemplateImportAbilityRspBO rspBO = new DycActInitialDataTemplateImportAbilityRspBO();
        if (StringUtils.isEmpty(reqBO.getUrl())) {
            rspBO.setRespDesc("模板导入URL不能为空");
            return rspBO;
        }
        //解析前台类目
        List<DycActQueryCatalogListBO> guideBOList = getGuideBOList(reqBO.getUrl());
        dycActSkuGuideRepository.importGuide(guideBOList);
        return rspBO;
    }



//    /**
//     * 读取后台类目模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<UccEMdmCatalogBo> getCatalogBOList(String url) {
//        List<UccEMdmCatalogBo> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 0);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    UccEMdmCatalogBo bo = new UccEMdmCatalogBo();
//                    int i = 0;
//                    String errorStr = null;
//
//                    String name1 = row.get(i++);
//                    bo.setCatalogName(name1);
//
//                    Long code1 = Long.parseLong(row.get(i++));
//                    bo.setCatalogId(code1);
//
//                    String name2 = row.get(i++);
//                    bo.setCatalogName2(name2);
//
//                    Long code2 = Long.parseLong(row.get(i++));
//                    bo.setCatalogId2(code2);
//
//                    String name3 = row.get(i++);
//                    bo.setCatalogName3(name3);
//
//                    Long code3 = Long.parseLong(row.get(i++));
//                    bo.setCatalogId3(code3);
//
//                    String name4 = row.get(i++);
//                    bo.setCatalogName4(name4);
//
//                    Long code4 = Long.parseLong(row.get(i++));
//                    bo.setCatalogId4(code4);
//
//                    String typeName = row.get(i++);
//                    bo.setTypeName(typeName);
//
//                    Long typeId = Long.parseLong(row.get(i++));
//                    bo.setTypeId(typeId);
//
//
//
//                    String taxCode = row.get(i++);
//                    bo.setTaxCode(taxCode);
//
//                    String taxName = row.get(i++);
//                    bo.setTaxName(taxName);
//
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取物料信息模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<MaterialInfoBO> getMaterialBOList(String url) {
//        List<MaterialInfoBO> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 1);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    MaterialInfoBO bo = new MaterialInfoBO();
//                    int i = 0;
//                    String errorStr = null;
//
//                    String code1 = row.get(i++);
//                    bo.setMaterialId(code1);
//
//                    String name1 = row.get(i++);
//                    bo.setMaterialName(name1);
//
//                    Long code2 = Long.parseLong(row.get(i++));
//                    bo.setCatalogId(code2);
//
//                    String name2 = row.get(i++);
//                    bo.setCatalogName(name2);
//
//                    String code3 = row.get(i++);
//                    if(StringUtils.isEmpty(code3)){
//                        i++;
//                    }else {
//                        bo.setMaterialModel(code3);
//                    }
//
//
//                    String name3 = row.get(i++);
//                    if(StringUtils.isEmpty(name3)){
//                        i++;
//                    }else {
//                        bo.setMaterialSpec(name3);
//                    }
//
//
//                    String measureName = row.get(i++);
//                    bo.setMeasureUnit(measureName);
//
//                    Long measureId = Long.parseLong(row.get(i++));
//                    bo.setMesureId(measureId);
//
//                    String shortDesc = row.get(i++);
//                    if(StringUtils.isEmpty(shortDesc)){
//                        i++;
//                    }else {
//                        bo.setShortDesc(shortDesc);
//                    }
//
//
//                    String longDesc = row.get(i++);
//                    if(StringUtils.isEmpty(longDesc)){
//                        i++;
//                    }else {
//                        bo.setLongDesc(longDesc);
//                    }
//
//
//                    String brandName = row.get(i++);
//                    if(StringUtils.isEmpty(brandName)){
//                        i++;
//                    }else {
//                        bo.setBrandName(brandName);
//                    }
//
//
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }

    /**
     * 读取前台类目模板信息
     *
     * @param url
     * @return
     */
    private List<DycActQueryCatalogListBO> getGuideBOList(String url) {
        List<DycActQueryCatalogListBO> list = new ArrayList<>();
        List<List<String>> data = new ArrayList<>();
        try {
            data = dealEcxel(url, 2, 0);
        } catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException(e.getMessage());
        }
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List<String> row : data) {
                    DycActQueryCatalogListBO bo = new DycActQueryCatalogListBO();
                    int i = 0;
                    String errorStr = null;



                    Long code1 = Long.parseLong(row.get(i++));
                    bo.setId(code1);

                    String name1 = row.get(i++);
                    bo.setName(name1);
//                    Integer order1 = Integer.parseInt(row.get(i++));
//                    bo.setViewOrder(order1);





                    Long code2 = Long.parseLong(row.get(i++));
                    bo.setId2(code2);
                    String name2 = row.get(i++);
                    bo.setName2(name2);
//                    Integer order2 = Integer.parseInt(row.get(i++));
//                    bo.setViewOrder2(order2);



                    Long code3= Long.parseLong(row.get(i++));
                    bo.setId3(code3);
                    String name3 = row.get(i++);
                    bo.setName3(name3);
//                    Integer order3 = Integer.parseInt(row.get(i++));
//                    bo.setViewOrder3(order3);

                    i++;

//                    Long typeId = Long.parseLong(row.get(i++));
//                    bo.setTypeId(typeId);

                    list.add(bo);
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
        }
        return list;
    }



//    /**
//     * 读取属性组模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<PropGrpBo> getGrpBOList(String url) {
//        List<PropGrpBo> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 3);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    PropGrpBo bo = new PropGrpBo();
//                    int i = 0;
//                    String errorStr = null;
//
//                    String code1 = row.get(i++);
//                    bo.setCommodityTypeName(code1);
//
//                    Long name1 = Long.parseLong(row.get(i++));
//                    bo.setCommodityTypeId(name1);
//
//                    String code2 = row.get(i++);
//                    bo.setCommodityPropGrpName(code2);
//
//                    Long name2 = Long.parseLong(row.get(i++));
//                    bo.setCommodityPropGrpId(name2);
//
//                    Integer code3 = Integer.parseInt(row.get(i++));
//                    bo.setCommodityPropGrpType(code3);
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取属性模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<CommdPropDefBO> getDefBOList(String url) {
//        List<CommdPropDefBO> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 4);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    CommdPropDefBO bo = new CommdPropDefBO();
//                    int i = 0;
//                    String errorStr = null;
//
//                    String code1 = row.get(i++);
//                    bo.setGrpNmae(code1);
//
//                    Long name1 = Long.parseLong(row.get(i++));
//                    bo.setGrpId(name1);
//
//                    String code2 = row.get(i++);
//                    bo.setShowName(code2);
//
//                    String name2 = row.get(i++);
//                    bo.setPropName(name2);
//
//                    Long propId = Long.parseLong(row.get(i++));
//                    bo.setCommodityPropDefId(propId);
//
//                    Integer tag = Integer.parseInt(row.get(i++));
//                    bo.setPropTag(tag);
//
//                    Integer type = Integer.parseInt(row.get(i++));
//                    bo.setPropType(type);
//
//                    Integer inputType = Integer.parseInt(row.get(i++));
//                    bo.setInputType(inputType);
//
//                    Integer requiredFlag = Integer.parseInt(row.get(i++));
//                    bo.setRequiredFlag(requiredFlag);
//
//                    Integer filterFlag = Integer.parseInt(row.get(i++));
//                    bo.setFilterFlag(filterFlag);
//
//                    Integer multiFlag = Integer.parseInt(row.get(i++));
//                    bo.setMultiFlag(multiFlag);
//
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取属性值模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<PropEntityValue> getValueBOList(String url) {
//        List<PropEntityValue> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 5);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    PropEntityValue bo = new PropEntityValue();
//                    int i = 0;
//                    String errorStr = null;
//
//                    String code1 = row.get(i++);
//                    bo.setPropName(code1);
//
//                    Long code2 = Long.parseLong(row.get(i++));
//                    bo.setPropId(code2);
//
//                    String name2 = row.get(i++);
//                    bo.setPropValue(name2);
//
//                    Long valueId = Long.parseLong(row.get(i++));
//                    bo.setPropValueListId(valueId);
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取计量单位模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<UccCommodityMeasureBO> getMeasureBOList(String url) {
//        List<UccCommodityMeasureBO> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 6);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    UccCommodityMeasureBO bo = new UccCommodityMeasureBO();
//                    int i = 0;
//                    String errorStr = null;
//
//                    Long code1 = Long.parseLong(row.get(i++));
//                    bo.setMeasureId(code1);
//
//                    String code2 = row.get(i++);
//                    bo.setMeasureName(code2);
//
//                    String limit = row.get(i++);
//                    if(StringUtils.isEmpty(limit)){
//                        i++;
//                    }else {
//                        bo.setDecimalLimit(Integer.parseInt(limit));
//                    }
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取品牌模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<UccBrandDateBO> getBrandBOList(String url) {
//        List<UccBrandDateBO> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 7);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    UccBrandDateBO bo = new UccBrandDateBO();
//                    int i = 0;
//                    String errorStr = null;
//
//                    Long code1 = Long.parseLong(row.get(i++));
//                    bo.setBrandId(code1);
//
//                    String code2 = row.get(i++);
//                    bo.setBrandName(code2);
//
//                    String enName = row.get(i++);
//                    if(StringUtils.isEmpty(enName)){
//                        i++;
//                    }else {
//                        bo.setBrandEnName(enName);
//                    }
//
////                    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
////                    String effTime = row.get(i++);
////                    if(StringUtils.isEmpty(effTime)){
////                        i++;
////                    }else {
////
////                        Date date = dateFormat.parse(effTime);
////                        bo.setEffTime(date);
////                    }
////
////
////                    String expTime = row.get(i++);
////                    if(StringUtils.isEmpty(expTime)){
////                        i++;
////                    }else {
////                        Date dateExp = dateFormat.parse(expTime);
////                        bo.setExpTime(dateExp);
////                    }
//
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }
//
//    /**
//     * 读取频道模板信息
//     *
//     * @param url
//     * @return
//     */
//    private List<UccRelChannelCatalogBo> getRelChannelBOList(String url) {
//        List<UccRelChannelCatalogBo> list = new ArrayList<>();
//        List<List<String>> data = new ArrayList<>();
//        try {
//            data = dealEcxel(url, 2, 8);
//        } catch (Exception e) {
//            e.printStackTrace();
//            throw new ZTBusinessException(e.getMessage());
//        }
//        try {
//            if (CollectionUtils.isNotEmpty(data)) {
//                for (List<String> row : data) {
//                    UccRelChannelCatalogBo bo = new UccRelChannelCatalogBo();
//                    int i = 0;
//                    String errorStr = null;
//
//                    i++;
//
//                    Long guide1 = Long.parseLong(row.get(i++));
//                    bo.setGuide1(guide1);
//
//                    i++;
//
//                    Long guide2 = Long.parseLong(row.get(i++));
//                    bo.setGuide2(guide2);
//
//                    i++;
//
//                    Long guide3 = Long.parseLong(row.get(i++));
//                    bo.setGuide3(guide3);
//
//                    String cnannleName = row.get(i++);
//                    bo.setChannelName(cnannleName);
//
//                    Long cnannleId = Long.parseLong(row.get(i++));
//                    bo.setChannelId(cnannleId);
//
//                    String cnannleCode = row.get(i++);
//                    bo.setChannelCode(cnannleCode);
//
//                    list.add(bo);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace();
//            throw new ZTBusinessException("数据出现问题,请检查格式!" + e.getMessage());
//        }
//        return list;
//    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty(url)) {
            return new ArrayList<>();
        }
        //数据处理
        List<List<String>> lines = new ArrayList<>();
        try {
            ExcelNewUtils.getExcelDate(url, lines, startReadLine, sheetAt,fileClient);
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("处理Excel失败");
        }
        log.info("读取到的数据：" + JSONObject.toJSONString(lines));
        return lines;
    }
}
