package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActModifyLaborUnionService;
import com.tydic.dyc.act.service.bo.DycActModifyLaborUnionReqBO;
import com.tydic.dyc.act.service.bo.DycActModifyLaborUnionRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 标题：DycActModifyLaborUnionServiceImpl
 * 说明：
 * 时间： 2024-03-27 10:45
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActModifyLaborUnionServiceImpl implements DycActModifyLaborUnionService {

    @Autowired
    private DycActIaborModel dycActIaborModel;
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActModifyLaborUnionRspBO modifyLaborUnion(DycActModifyLaborUnionReqBO reqBO) {
        checkParam(reqBO);

        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityScopeOrgId(reqBO.getLaborUnionId());
        List<DycActivityBaseInfo> baseInfos = dycActActivityModel.queryActivityList(activityDO);
        for (DycActivityBaseInfo dycActivityDO : baseInfos) {
            if (!(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN.equals(dycActivityDO.getActivityState())
                    && DycActivityConstants.Settle_Flag.Settle_Flag_ONE.equals(dycActivityDO.getIsSettleFlag()))) {
                throw new ZTBusinessException("当前工会存在活动中，不允许修改！");
            }
        }

        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        dycActIaborModel.modifyLaborUnion(dycActivityDO);
        DycActModifyLaborUnionRspBO rspBO = new DycActModifyLaborUnionRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActModifyLaborUnionReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("参数为空！");
        }
        if (null == reqBO.getLaborUnionId()) {
            throw new ZTBusinessException("工会id为空！");
        }
        if (!StringUtils.hasText(reqBO.getLaborUnionName())) {
            throw new ZTBusinessException("工会名称为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getRelaOrgList())) {
            throw new ZTBusinessException("关联机构列表为空！");
        }
    }
}
