package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.service.api.DycActModifySkuPoolService;
import com.tydic.dyc.act.service.bo.DycActModifySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActModifySkuPoolRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * 类名： DycActModifySkuPoolServiceImpl
 * 说明：商品池修改服务实现
 *
 * @author： lishiqing
 * 时间： 2024/4/15 19:57
 */
@HTServiceImpl
public class DycActModifySkuPoolServiceImpl implements DycActModifySkuPoolService {

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @Override
    public DycActModifySkuPoolRspBO modifySkuPool(DycActModifySkuPoolReqBO reqBO) {
        this.valData(reqBO);
        ActSkuPoolReqBO poolReqBO = new ActSkuPoolReqBO();
        poolReqBO.setPoolId(reqBO.getPoolId());
        poolReqBO.setPoolName(reqBO.getPoolName());
        poolReqBO.setRemark(reqBO.getRemark());
        poolReqBO.setUpdateOperName(reqBO.getUpdateOperName());
        poolReqBO.setUpdateTime(new Date());
        dycActSkuPoolModel.modifySkuPool(poolReqBO);
        return ActRu.success(DycActModifySkuPoolRspBO.class);
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void valData(DycActModifySkuPoolReqBO reqBO) {
        // 入参非空校验
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池修改服务入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPoolId())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池修改服务入参商品池ID[poolId]为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPoolName())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池修改服务入参商品池名称[poolName]为空");
        }
        // 校验名字是否重复
        ActSkuPoolReqBO skuPoolReqBO = new ActSkuPoolReqBO();
        skuPoolReqBO.setPoolName(reqBO.getPoolName());
        skuPoolReqBO.setExitsPoolId(reqBO.getPoolId());
        List<ActSkuPoolBO> data = dycActSkuPoolModel.queryActSkuPoolList(skuPoolReqBO).getData();
        if (CollectionUtil.isNotEmpty(data)) {
            throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR,"商品池名称重复");
        }
    }
}
