package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActCheckBillModel;
import com.tydic.dyc.act.model.bo.DycActCheckBillQryDO;
import com.tydic.dyc.act.model.bo.DycActOrdNumMoneyInfo;
import com.tydic.dyc.act.service.api.DycActQryOrderNumAndMoneyService;
import com.tydic.dyc.act.service.bo.DycActQryOrderNumAndMoneyReqBO;
import com.tydic.dyc.act.service.bo.DycActQryOrderNumAndMoneyRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName DycActQryOrderNumAndMoneyServiceImpl
 * @Author 14051
 * @Date 2024/4/17 17:28
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActQryOrderNumAndMoneyServiceImpl implements DycActQryOrderNumAndMoneyService {

    @Autowired
    private DycActCheckBillModel dycActCheckBillModel;

    @Override
    public DycActQryOrderNumAndMoneyRspBO qryOrderNumAndMoney(DycActQryOrderNumAndMoneyReqBO reqBO) {
        DycActCheckBillQryDO dycActCheckBillQryDO = new DycActCheckBillQryDO();
        dycActCheckBillQryDO.setActivityId(reqBO.getActivityId());
        DycActOrdNumMoneyInfo dycActOrdNumMoneyInfo = dycActCheckBillModel.qryOrdNumAndMoney(dycActCheckBillQryDO);
        DycActQryOrderNumAndMoneyRspBO rspBO = new DycActQryOrderNumAndMoneyRspBO();
        BeanUtils.copyProperties(dycActOrdNumMoneyInfo, rspBO);
        return rspBO;
    }
}
