package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActAlreadySyncExternalUserModel;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserDO;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserInfo;
import com.tydic.dyc.act.service.api.DycActQueryActAlreadySyncExternalUserListService;
import com.tydic.dyc.act.service.bo.ActAlreadySyncExternalUserBO;
import com.tydic.dyc.act.service.bo.ActAlreadySyncExternalUserReqBO;
import com.tydic.dyc.act.service.bo.ActAlreadySyncExternalUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryActAlreadySyncExternalUserListServiceImpl
 * 说明：
 * 时间： 2024-04-15 16:58
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActAlreadySyncExternalUserListServiceImpl implements DycActQueryActAlreadySyncExternalUserListService {
    @Autowired
    private DycActAlreadySyncExternalUserModel dycActAlreadySyncExternalUserModel;

    @Override
    public ActAlreadySyncExternalUserRspBO queryActAlreadySyncExternalUserList(ActAlreadySyncExternalUserReqBO reqBO) {
        ActAlreadySyncExternalUserDO userDO = new ActAlreadySyncExternalUserDO();
        BeanUtils.copyProperties(reqBO, userDO);
        List<ActAlreadySyncExternalUserInfo> actAlreadySyncExternalUserInfos = dycActAlreadySyncExternalUserModel.queryActAlreadySyncExternalUserList(userDO);
        List<ActAlreadySyncExternalUserBO> userBOS = JSON.parseArray(JSON.toJSONString(actAlreadySyncExternalUserInfos), ActAlreadySyncExternalUserBO.class);
        ActAlreadySyncExternalUserRspBO rspBO = new ActAlreadySyncExternalUserRspBO();
        rspBO.setDate(userBOS);
        return rspBO;
    }
}
