package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQueryActiveBaseInfoService;
import com.tydic.dyc.act.service.bo.DycActActiveBaseDetailInfoBO;
import com.tydic.dyc.act.service.bo.DycActActivitySupplierInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActiveBaseInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActiveBaseInfoRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActActiveBaseInfoQueryService
 * 说明：活动基本信息详情查询
 * 时间： 2023-12-12 11:12
 * 作者 @author zhoulu
 */

@HTServiceImpl
public class DycActQueryActiveBaseInfoServiceImpl implements DycActQueryActiveBaseInfoService {

    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActQueryActiveBaseInfoRspBO queryActiveBaseInfo(DycActQueryActiveBaseInfoReqBO reqBO) {
        DycActQueryActiveBaseInfoRspBO rspBO = new DycActQueryActiveBaseInfoRspBO();
        if (ObjectUtil.isEmpty(reqBO.getActivityId())) {
            throw new ZTBusinessException("活动id不能为空");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> dycActivityBaseInfos = dycActActivityModel.queryActivityList(dycActivityDO);

        DycActActiveBaseDetailInfoBO activityBaseDetail = new DycActActiveBaseDetailInfoBO();
        if (dycActivityBaseInfos.size() > 0) {
            BeanUtils.copyProperties(dycActivityBaseInfos.get(0), activityBaseDetail);
        }
        if (!DycActivityConstants.ActivityState.ACTIVITY_STATE_ONE.equals(activityBaseDetail.getActivityState())) {
            DycProcessDO dycProcessDO = new DycProcessDO();
            dycProcessDO.setObjId(reqBO.getActivityId());
            DycActivityFlowInstanceInfo instanceInfo = dycActProcessModel.queryActivityFlowInstanceSingleTime(dycProcessDO);
            if(null != instanceInfo) {
                activityBaseDetail.setProcInstId(instanceInfo.getFlowInstId());
            }
        }
        BasePageRspBo<DycActivitySupplierInfo> pageRspBo = dycActActivityModel.queryActiveSupplierList(dycActivityDO);
        List<DycActActivitySupplierInfoBO> supplierInfoBOS = JSON.parseArray(JSON.toJSONString(pageRspBo.getRows()), DycActActivitySupplierInfoBO.class);
        activityBaseDetail.setActivitySupplierList(supplierInfoBOS);
        rspBO.setActivityBaseDetail(activityBaseDetail);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
