package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.DycActActivityApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityApprovePageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityApprovePageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityApprovePageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动审批列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月28日 11:35
 */
@HTServiceImpl
public class DycActQueryActivityApprovePageListServiceImpl implements DycActQueryActivityApprovePageListService {
    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActQueryActivityApprovePageListRspBO queryActivityApprovePageList(DycActQueryActivityApprovePageListReqBO reqBO) {
        DycProcessDO dycProcessDO = JSON.parseObject(JSON.toJSONString(reqBO), DycProcessDO.class);
        BasePageRspBo<DycActActivityApproveBaseInfo> dycActActivityApproveBaseInfoBasePageRspBo = dycActProcessModel.queryActivityApprovePageList(dycProcessDO);
        DycActQueryActivityApprovePageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActActivityApproveBaseInfoBasePageRspBo), DycActQueryActivityApprovePageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
