package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.ActSysDictionaryModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRspDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeBaseInfoService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeBaseInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeBaseInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：DycActQueryActivityChangeBaseInfoServiceImpl
 * 说明：活动变更单基本信息查询服务
 * 时间： 2023-12-22 14:18
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityChangeBaseInfoServiceImpl implements DycActQueryActivityChangeBaseInfoService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Autowired
    private ActSysDictionaryModel actSysDictionaryModel;

    @Override
    public DycActQueryActivityChangeBaseInfoRspBO queryActivityChangeBaseInfo(DycActQueryActivityChangeBaseInfoReqBO reqBo) {
        DycActivityChangeDO activityChangeDo = JSON.parseObject(JSON.toJSONString(reqBo), DycActivityChangeDO.class);
        DycActivityChangeRspDO dycActivityChangeRspDo = dycActivityChangeModel.queryActivityChangeBaseInfo(activityChangeDo);
        DycActQueryActivityChangeBaseInfoRspBO rspBo = JSON.parseObject(JSON.toJSONString(dycActivityChangeRspDo), DycActQueryActivityChangeBaseInfoRspBO.class);
        translators(rspBo);
        return rspBo;
    }

    /**
     * 字段翻译
     * @param rspBO
     */
    private void translators(DycActQueryActivityChangeBaseInfoRspBO rspBO){
        List<String> pCodes = new ArrayList<>(2);
        pCodes.add(DycActivityConstants.PCode.ACTIVITY_TYPE);
        pCodes.add(DycActivityConstants.PCode.CHANGE_STATE);
        Map<String,Map<String,String>> map = getDictionaryMap(pCodes);
        rspBO.getChangeBaseDetail().setActivityTypeDesc(getDic(DycActivityConstants.PCode.ACTIVITY_TYPE,rspBO.getChangeBaseDetail().getActivityType().toString(),map));
        rspBO.getChangeBaseDetail().setChangeStateStr(getDic(DycActivityConstants.PCode.CHANGE_STATE,rspBO.getChangeBaseDetail().getChangeState(),map));
    }

    /**
     * 翻译获取
     * @param pCode
     * @param code
     * @param map
     * @return
     */
    private String getDic(String pCode,String code,Map<String,Map<String,String>> map){
        if(!CollectionUtils.isEmpty(map)){
            if(map.containsKey(pCode)){
              return map.get(pCode).get(code);
            }else {
                return null;
            }
        }else {
            return null;
        }

    }

    /**
     * 字典翻译获取
     * @param pCodes
     * @return
     */
    private Map<String,Map<String,String>> getDictionaryMap(List<String> pCodes){
       return actSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
